require.config({
    paths: {
        'jquery': "vendor/jquery-3.1.1.min",
        'cytoscape': "vendor/cytoscape/cytoscape",
        //'cytoscape-panzoom': 'https://cdnjs.cloudflare.com/ajax/libs/cytoscape-panzoom/2.4.0/cytoscape-panzoom.min',
        'cytoscape-cose-bilkent': "vendor/cytoscape/cytoscape-cose-bilkent",
        'd3': "vendor/d3/d3.min"
    }
});

var getNetwork = function (name, index) {
    console.log("getting network", 'name', name, 'index', index);
    var url = "http://perseus/networks/network/" + index;
    return $.getJSON(url).then(function (network) { return network });
}
var getConditions = function (name, index) {
    console.log("getting conditions", 'name', name, 'index', index);
    var url = "http://perseus/networks/conditions/" + index;
    return $.getJSON(url).then(function (conditions) { return conditions });
}

require(['config', 'jquery', 'cytoscape', 'cytoscape-cose-bilkent', 'pieChart'], function (config, $, cytoscape, regCose, pieChart) {
    regCose(cytoscape);
    var stylesheet = cytoscape.stylesheet();
    stylesheet.selector("node[label]")
        .css({
            'text-halign': 'right',
            'text-valign': 'center',
            'label': 'data(label)',
            'font-size': 30
        });
    if (config.network === "kinase-substrate") {
        console.log("visualizing kinase-substrate network");
        stylesheet
            .selector("node[colors][pieSize]")
            .css(pieChart.css);
    }
    else if (config.network === "pull-down") {
        console.log("visualizing pull-down network");
        stylesheet
            .selector("node")
            .css({
                'background-color' : function(node) {
                    if (node.data('isBait')) {
                        return 'green';
                    }
                    return 'blue';
                }
            })
            .selector("edge")
            .css({
                'line-color': function (edge) {
                    return edge.data('color');
                },
                'width': function (edge) {
                    return 5 * edge.data('thickness');
                },
            });
    }

    var layoutOptions = {
        name: 'cose-bilkent',
        animate: true,
        idealEdgeLength: 200,
        nodeRepulsion: 60000
    };

    var cy = cytoscape({
            container: document.getElementById("cy"),
            style: stylesheet,
            ready: function() {
                //$('#cy').cytoscapePanzoom();
            }
    });

    cy.on('tap', 'node', function (event) {
        console.log(event.cyTarget.data());
    });

    cy.on('tap', 'edge', function (event) {
        console.log(event.cyTarget.data());
    });

    document
        .getElementById("relayout")
        .addEventListener("click", function () {
            cy.layout(layoutOptions);
        });

	document
		.getElementById("export")
		.addEventListener("click", function() {
			var base64 = cy.png({ output: "base64" });
			console.log(base64);
			perseus.export(base64);
		});

    $.getJSON("http://perseus/networks/names", function (names) {
        console.log("got names", names);
        $.when.apply($, names.map(getNetwork)).done(function () {
            console.log('got networks', arguments);
            var graphs = Array.from(arguments);
            var conditions = graphs.map(function (graph) {
                if (graph.conditions) {
                    return graph.conditions.map(function(condition) {
                        return { text: condition, checked: true };
                    });
                } else {
                    return false;
                }
            });
            console.log('conditions', conditions);
            var layouted = graphs.map(function() {
                return false;
            });
            var select = document.createElement("select");
            $.each(names, function (index, name) {
                var ele = document.createElement("option");
                $(ele)
                    .attr("value", index)
                    .text(name);
                $(select).append(ele);
            });
            var checkConditions = document.createElement("fieldset");
            var previousIndex = -1;
            $(select).change(function () {
                var removed = cy.elements().remove();
                console.log('removed', removed);
                if (previousIndex > -1) {
                    graphs[previousIndex] = removed;
                    console.log('saving to previous index', previousIndex);
                }
                var i = this.selectedIndex;
                var newElements = graphs[i];
                console.log('selected', i, 'adding', newElements);
                cy.add(newElements);
                if (!layouted[i]) {
                    console.log('running layout');
                    cy.layout(layoutOptions);
                    layouted[i] = true;

                }
                if (conditions && conditions.some(function (x) { return x && x.length > 0 })) {
                    var graphConditions = conditions[i];
                    console.log("conditions", graphConditions);
                    $(checkConditions).empty();
                    var conditionsLabel = document.createElement("label");
                    $(conditionsLabel).text("Conditions");
                    checkConditions.append(conditionsLabel);
                    $.each(graphConditions, function (index, condition) {
                        var checkbox = document.createElement("input");
                        $(checkbox).attr({ type: "checkbox", id: index, checked: condition.checked, text: condition.text });
                        $(checkbox).change(function () {
                            if (this.checked) {
                                console.log('showing', condition.text);
                                cy.style().selector("edge." + condition.text).style('visibility', 'visible').update();

                            } else {
                                console.log('hiding', condition.text);
                                cy.style().selector("edge." + condition.text).style('visibility', 'hidden').update();
                            }
                            condition.checked = this.checked;
                            console.log('graph conditions', graphConditions);
                        });
                        var label = document.createElement("label");
                        $(label).text(condition.text).attr({ for: index });
                        $(checkConditions).append(checkbox);
                        $(checkConditions).append(label);
                    });
                }
                previousIndex = i;
            }).appendTo($(".toolbar"));
            $(checkConditions).appendTo($(".toolbar"));
            $(select).val("0").change();
        });
    });
});