﻿# Change Log
All notable changes to Perseus will be documented in this file.

## [1.6.6.0] - 2019-05-13
### Fixed
 - Sessions with `Matrix => Python` and `Matrix => R` activities no longer fail to serialize on safe.
 - Message error added in ScatterPlot when some instances from the matrix are missed
 - "Matching columns by name" fixed
 - "Matching SAMPLES by column name" added
 - Kruskal Wallis Test added

### Added
 - PluginPHOTON now supports running ANAT as a separate step. This allows for more workflows to use the automatic subnetwork reconstruction.

## [1.6.5.0] - 2019-01-27
### Changed
 - Kinase substrate enrichment analysis: Result columns are now sorted by type, making it easier to select a specific score type for all conditions.
### Fixed
 - Hawaii plot: Fixed an error with the `.pdf` export of the volcano detail plot.
 - Network Annotate edges: No longer ignores 'join style' and 'add original row numbers' arguments when matching to 'Target' column.
 - Kinase substrate enrichment analysis: No longer crashes after reloading session.
 - Hierarchical clustering: When selecting cluster members the correct profile is highlighted
   [[Perseus-224](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-224)].

## [1.6.2.3] - 2018-10-15
### Added
 - Hawaii plot now allows users to specify the number of permutations used for the FDR calculation and
   bait correlations can be used to define class C interactors upon creation of the network.
   Experimental designs with multiple conditions are now separated properly in all tables and export.
   'Condition' and 'Class' columns were added to the edge table for better visualization and easier
   filtering
 - 'Matching rows by name', 'Annotate nodes', and 'Annotate edges' now support outer joins,
   can add original row numbers to matched rows, and include an 'Ignore case' option
   [[Perseus-134](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-134)].
 - Kinase substrate enrichment analysis now implements all scores proposed by Casado et al. (mean,
   enrichment, z-score, p-value, q-value). Estimation of global mean and standard deviation have
   higher accuracy when leveraging the imporved 'Annotate edges'.
 - Network nodes can now be filtered for duplicated in a specified column.
 - Adding annotation rows from matrix now includes numerical columns.
 - Heatmap cluster table now includes a column denoting the color assigned to the cluster.
 - Network filter for neighbors now inlcudes a 'depth' parameter that allows
   to retain neighbors of n-th degree.
 - New 'Correlate rows' multi-processing activity. Calculates correlations between the rows
   of two matrices. Useful e.g. in the co-expression workflow for calculating kME
   values by correlating proteins and module eigengene profiles.

### Fixed
 - Hawaii/volcano plot: Changing labels to bold font now works as expected. Set proper image for 'Show labels' button
   [[Perseus-216](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-216)].
 - Handling of string rows in 'Change column type' improved which could lead to errors later in the workflow
   [[Perseus-214](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-214)].
 - Hawaii plot: The button for controlling if labels of selected points are displayed works as expected
   [[Perseus-216](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-216)].
 - CefSharp browser logfile `debug.log` is no longer written to file.
 - Co-expression clustering does not enter an endless loop when a large number of modules was found.
   Determining the correct color from the module name was improved.
 - When loading a session co-expression clustering analysis output data will no longer be duplicated
 - Summary statistics (columns): Fixed a bug that could lead to bugs in down-stream analysis / text export.
 - Summary statistics (rows) now handels rows without valid values rather than producing an error message.
 - Fisher exact test results no longer contain empty annotation rows that lead to errors downstream.
 - Clustering heatmap: Exporting row clusters works without errors
   [[Perseus-217](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-217)].
 - Connected components does no longer treat directed networks as undirected.
 - Category counting: Fixed a bug that could lead to errors in downstream analyses.
 - 1D annotation enrichment: Fixed a bug that could lead to errors in downstream analyses.

## [1.6.2.2] - 2018-07-26
### Added
 - Experimental support for SVG graphics export.
 - Hawaii plot now includes correlations between baits and prey proteins as an additional layer of information.

### Fixed
 - Network analysis with PHOTON now no longer crashes when assembling results.
 - Co-expression clustering no longer fails when the expression matrix includes 'bad' rows as deterimned by WGCNA.

## [1.6.2.1] - 2018-07-04
### Added
 - Network collection data type and associated activities.
 - Hawaii (multi-volcano) plot.
 - New activity to 'Combine annotation columns' to combine annotations by different strategies (union, intersection, majority).

### Changed
 - 'Rename columns [regex]' is no longer limited to main columns only.
 - Bug fix in NGSupload activity - error during changing parameters

### Fixed
 - Combine main columns fixed [[Perseus-188](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-188)].
 - 1D annotation enrichment now correctly resets quality and imputed matrices.
 - Session saving should fail less frequently with "the internal array ..." error message (text column serialization improved).
 - No more non-monotone q-values from Benjamini-Hochberg FDR [[Perseus-89](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-89)].
 - Matching columns by name will not crash if categorical columns are present [[Perseus-196](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-196)].
 - The one sample test now reports the q-value [[Perseus-200](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-200)].
 - Groups are no longer swapped in paired two-sample test [[Perseus-111](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-111)].
 - Removing analyses from data nodes now correctly removes both the node and the tab [[Perseus-201](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-201)] [[Perseus-211](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-211)].
 - A useful error message is now displayed if renaming column names by regex leads to duplicate column names [[Perseus-204](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-204)]
 - Reading from files where fields contain internal quotes now yields the expected results [[Perseus-206](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-206)].
 - Histogram has vertical axis
[[Perseus-174](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-174)].

## [1.6.1.0] - 2017-12-08
### Added
 - Specify name for annotation row created from regular expression.
 - Cluster constraints added to hierarchical clustering
 - Volcano plot: Display group names in x-axis label [[Perseus-156](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-156)]
 - Session files are not overwritten with a corrupted file if saving session fails [[Perseus-154](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-154)].
 - Label column in volcano/scatter plots are now 'Gene Name' by default. Any manual selection will be saved with the session [[Perseus-155](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-155)].
 - Readded 'Annotation matrix' activity [[Perseus-165](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-165)].
 - 'Raw upload' now supports also space-separated files.

### Fixed
 - Multi-scatter plot: remove dummy button from GUI. Do not limit correlation calculation to visible plots only. No more missing values in correlation column [[Perseus-150](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-150)].
 - Imputation matrix from not expanded in `Expand multi-numeric and text columns` leading to errors downstream [[Perseus-146](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-146)].
 - Hierarchical Clustering - Image export [[Perseus-144](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-144)].
 - Hierarchical clustering correctly handling duplicate rows in k-means pre-clustering: Fixed an error occurring when the total number of rows in the data was larger than k but the unique number of rows was less than k [[Perseus-164](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-164)].
 - Missing configuration files were re-added to the release. Activity headers will now be ordered as before.
 - GUI would crash after switching many times between analyses [[Perseus-182](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-182)].
 - Fix annotation row copying in 'Matching rows by name' which would lead to errors downstream [[Perseus-179](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-179)].
 - When using 'Add annotation' and 'Back to base identifiers' `mainAnnot*` is now again selected by default.

## [1.6.0.7] - 2017-07-26
### Fixed
 - Enabled saving of large sessions due to changes in the way annotation rows and columns are serialized
 - Fixed a bug in one-sided volcano plot, where processing would never finish.
 - Configuring scatter plot [[Perseus-129](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-129)].
 - Resize tables after loading session [[Perseus-123](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-123)].
 - Find dialog stays on top [[Perseus-125](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-125)].
 - Histogram: Change number of bins and select from imputation [[Perseus-118](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-118)].
 - Fix font-selection [[Perseus-122](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-122)].
 - Fix bug in annotation creation that made filtering rows crash [[Perseus-132](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-132)].

### Added
 - [Process text columns](http://www.coxdocs.org/doku.php?id=perseus:user:activities:matrixprocessing:rearrange:processtextcolumns) now includes an optional replacement string.
 - Report version number of `.sps` session file on failed load [[Perseus-14](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-14)].

### Changed
 - Volcano Plot: Reordered parameters to be consistent with the interface of the 'Two sample test'. `Group 1` is now
  on the right side of the plot. The x-axis label was adjusted accordingly.

## [1.5.8.0] - 2017-03-13
### Added
 - Winforms based GUI.

## [1.5.6.0] - 2016-10-31
### Fixed
 - Width adjustment - correct behaviour also on very small sample size due to change of definition of quantiles.

### Added
 - Numeric venn diagram now also possible on numerical columns.
 - Replace missing from gaussion possible on numerical columns.
 - Overview in workflow window.

## [1.5.5.3] - 2016-06-30
### Fixed
 - Reitroduced non-null check in FloatMatrixIndexer which avoids some crashes.
 - Crash in 'Categorical annotation rows' avoided.

## [1.5.5.2] - 2016-06-29
### Fixed
 - Critical bug in NGS importer fixed that lead to crashes.
 - Bug in 'Matching rows by name' fixed that resulted in crashes after applying 'Combine main columns' to one of the input matrices.

## [1.5.5.1] - 2016-06-27
### Fixed
 - Changed annotation download link to annotations.perseus-framework.org [[Perseus-120](https://maxquant.myjetbrains.com/youtrack/issue/Perseus-120)].

## [1.5.5.0] - 2016-06-16
### Added
 - Feature set corresponds to what is described in the publication Tyanova et al. (2016) Nature Methods, doi:10.1038/nmeth.3901.
